<?php 
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "include/includeBase.php";
    include "../gUtil/GestoreUpload.php";
    include "../gUtil/GestoreTabella.php";
    include "../classi/Tabella.php";
    
    include "include/controlloLogin.php";
    
    $impostazioni = recuperaImpostazioni($geecomDb);
    $status       = isset($_GET["status"]) ? filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT) : 0;
    
    $gestoreUpload = new GestoreUpload("",array(),100,"../immagini",100,"");
    $gestoreUploadFileMultimediali = new GestoreUpload("",array(),100,"../file",100,"");
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
        <title>Geecom CMS - gestione risorse</title>
    </head>
    <body>
      
    <header>
        <?php 
            include "include/barraSuperiore.php";
            
            include "include/header.php";
            
            include "include/barraMenu.php";
        ?>
    </header>
       
    <main role="main" class="bg-light" id="main">
        <div class="page-builder container-fluid">
            <div class="row py-4">
                <div class="col-12">
                    <?php 
                        if($status==200) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni generali aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                    <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==210) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni registrazione aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                    <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==240) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni footer aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                    <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==250) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Inclusioni aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                    <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==260) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni cookie aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==270) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni SEO aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==271) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni API aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==275) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni SMTP aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==280) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni sicurezza aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==285) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Template email aggiornato
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==286) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Nuovo template email creato
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==290) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Impostazioni prodotti aggiornate
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                        else if($status==310) {
                            echo"<div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                Colori configurazione aggiornati
                                <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                      <span aria-hidden=\"true\">&times;</span>
                                </button>
                            </div>";
                        }
                    ?>
                </div>

                <div class="col-2 col-sm-4 col-lg-3 col-xl-2 pr-0 align-self-start sticky-top">
                    <ul class="nav nav-tabs nav-tabs--vertical nav-tabs--left">
                        <li class="nav-item">
                            <a href="#fileDaScaricare" class="nav-link <?php echo(($status==200 || $status==0) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="file scaricabili"><i class="fas fa-file-download d-sm-inline-block d-flex justify-content-center"></i><span class="d-none d-sm-inline-block ml-sm-2">File scaricabili</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#immaginiArticoli" class="nav-link <?php echo(($status==210) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="immagini"><i class="fas fa-file-image d-sm-inline-block d-flex justify-content-center"></i><span class="d-none d-sm-inline-block ml-sm-2">Immagini articoli</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#immaginiGallerie" class="nav-link <?php echo(($status==210) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="immagini"><i class="fas fa-file-image d-sm-inline-block d-flex justify-content-center"></i><span class="d-none d-sm-inline-block ml-sm-2">Immagini gallerie</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#immaginiSlider" class="nav-link <?php echo(($status==210) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="immagini"><i class="fas fa-file-image d-sm-inline-block d-flex justify-content-center"></i><span class="d-none d-sm-inline-block ml-sm-2">Immagini slider</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#immaginiPopup" class="nav-link <?php echo(($status==210) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="immagini"><i class="fas fa-file-image d-sm-inline-block d-flex justify-content-center"></i><span class="d-none d-sm-inline-block ml-sm-2">Immagini popup</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#immaginiPortfolio" class="nav-link <?php echo(($status==210) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="immagini"><i class="fas fa-file-image d-sm-inline-block d-flex justify-content-center"></i><span class="d-none d-sm-inline-block ml-sm-2">Immagini portfolio</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#altreImmagini" class="nav-link <?php echo(($status==210) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="immagini"><i class="fas fa-file-image d-sm-inline-block d-flex justify-content-center"></i><span class="d-none d-sm-inline-block ml-sm-2">Altre immagini</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#audio" class="nav-link <?php echo(($status==220) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="impostazioni contabilità"><i class="fas fa-file-audio d-sm-inline-block d-flex justify-content-center"></i><span class="d-none d-sm-inline-block ml-sm-2">Audio</span></a>
                        </li>
                        <li class="nav-item">
                            <a href="#video" class="nav-link <?php echo(($status==300 || $status==310) ? "active" : "")  ?>" data-toggle="tab" role="tab" aria-controls="aspetto"><i class="fas fa-file-video d-sm-inline-block d-flex justify-content-center"></i><span class="d-none d-sm-inline-block ml-sm-2">Video</span></a>
                        </li>
                    </ul>
                </div>
                <div class="col-10 col-sm-8 col-lg-9 col-xl-10">
                    <div class="tab-content">
                        <div class="tab-pane fade show <?php echo(($status==200 || $status==0) ? "active" : "")  ?>" id="fileDaScaricare" role="tabpanel">
                            <?php 
                                include "include/risorse/fileScaricabili.php";
                            ?>
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==210) ? "active" : "")  ?>" id="immaginiArticoli" role="tabpanel">
                            <?php 
                                include "include/risorse/immaginiArticoli.php"; 
                            ?>                  
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==210) ? "active" : "")  ?>" id="immaginiGallerie" role="tabpanel">
                            <?php 
                                include "include/risorse/immaginiGallerie.php"; 
                            ?>                  
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==210) ? "active" : "")  ?>" id="immaginiSlider" role="tabpanel">
                            <?php 
                                include "include/risorse/immaginiSlider.php"; 
                            ?>                  
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==210) ? "active" : "")  ?>" id="immaginiPopup" role="tabpanel">
                            <?php 
                                include "include/risorse/immaginiPopup.php"; 
                            ?>                  
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==210) ? "active" : "")  ?>" id="immaginiPortfolio" role="tabpanel">
                            <?php 
                                include "include/risorse/immaginiPortfolio.php"; 
                            ?>                  
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==210) ? "active" : "")  ?>" id="altreImmagini" role="tabpanel">
                            <?php 
                                include "include/risorse/altreImmagini.php"; 
                            ?>                  
                        </div>
                        
                        <div class="tab-pane fade show <?php echo(($status==220) ? "active" : "")  ?>" id="audio" role="tabpanel">
                            <?php 
                                include "include/risorse/audio.php";
                            ?>
                        </div>
                        <div class="tab-pane fade show  <?php echo(($status==300 || $status==310) ? "active" : "")  ?>" id="video" role="tabpanel">
                            <?php 
                                include "include/risorse/video.php";
                            ?>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </main>

    <?php 
        include "include/footer.php";
        
        $percorsoBase = ""; // in questo file va reinizializzato perché è usato dai file per gestire l'aspetto
        include "include/modal/modalMenuComponenti.php";
                
        include "include/modal/cambiaPassword.php";
    
        include "include/modal/operazioneCompletata.php";
        
        include "include/jsBaseAreaAmministrativa.php";
    ?>
            
        <!--- MODALS -->
        
        <div class="modal fade" id="modalFileCaricato" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content bg-transparent">
                    <div class="modal-body m-0 p-0">
                        <div class="alert alert-success p-3 mb-0">
                            File caricato con con successo
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">×</span>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="modal fade" id="modalEliminaFileScaricabile" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare il file?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <img id="immagineComponenteDaEliminare" class="thumb d-none d-lg-block" src="">
                            <div class="align-self-center text-center">
                                <span class="align-self-center text-primary"><em id="nomeElementoDaEliminare"></em></span>
                            </div>
                        </div>
                        <input type="text" class="d-none" id="elementoDaEliminare">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eseguiEliminazioneFileScaricabile()"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
            
        <div class="modal fade" id="modalEliminaImmagine" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare l'immagine?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <img id="immagineDaEliminare" class="img-fluid" src="">
                        </div>
                        <input type="text" class="d-none" id="percorsoImmagine">
                        <input type="text" class="d-none" id="idDiv">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eliminaImmagine('../')"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="modal fade" id="modalEliminaFile" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Eliminare il file?</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                        <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="d-flex flex-row justify-content-center">
                            <p id="testoPercorsoFile"></p>
                        </div>
                        <input type="text" class="d-none" id="percorsoFileRisorsa">
                        <input type="text" class="d-none" id="idDivRisorsa">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                        <button type="button" class="btn btn-primary btn-sm" onclick="eliminaFileRisorsa('../')"><i class="fas fa-check"></i> Elimina</button>
                    </div>
                </div>
            </div>
        </div>
        
        <script type="text/javascript" src="../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmCaricaAltreImmagini").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.webp,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,esito) {
                    if(esito=="ok") {
                        $('#labelOperazioneCompletata').text("Immagine caricata");
                        $('#modalOperazioneCompletata').modal('show');
                    }
                    this.removeAllFiles();
                },
                params:{
                    operazione:"caricaImmaginiCartellaAltro"
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            });  	
            
            $("#frmCaricamentoAudio").dropzone({
                acceptedFiles: ".mp3,.ogg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,esito) {
                    if(esito=="ok") {
                        $('#labelOperazioneCompletata').text("Immagine caricata");
                        $('#modalOperazioneCompletata').modal('show');
                    }
                    this.removeAllFiles();
                },
                params:{
                    operazione:"caricaAudio"
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            });
            
            $("#frmCaricamentoVideo").dropzone({
                acceptedFiles: ".mp4",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,esito) {
                    if(esito=="ok") {
                        $('#labelOperazioneCompletata').text("Immagine caricata");
                        $('#modalOperazioneCompletata').modal('show');
                    }
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagine"
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            });  
            
            function apriPopupEliminaFile(idDiv,percorsoFileRisorsa) {
                $('#idDivRisorsa').val(idDiv);
                $('#percorsoFileRisorsa').val(percorsoFileRisorsa);
                $('#testoPercorsoFile').text(percorsoFileRisorsa);
                $('#modalEliminaFile').modal('show');
            }
            
            function eliminaFileScaricabile(id,nomeElemento) {
                $('#elementoDaEliminare').val(id);
                $('#nomeElementoDaEliminare').text(nomeElemento);
                $('#modalEliminaFileScaricabile').modal('show');
            }
            
            function eseguiEliminazioneFileScaricabile() {
                var id = $('#elementoDaEliminare').val();
                $.ajax({
                    type:"POST",
                    url:"../controller/controllerRisorse.php",
                    data:{
                        operazione:"eliminaFileScaricabile",
                        id:id
                    },
                    success:function(result) {
                        if(result=="ok") {
                            document.getElementById("fileScaricabile"+id).className = "d-none";
                            $('#modalEliminaFileScaricabile').modal('hide');
                        }
                        else {
                            alert(result);
                        }
                    },
                    error: function() {
                        alert("Si sono verificato problemi durante la richiesta, riprova tra qualche istante");
                    }
                });
            }
        </script>
    </body>
</html>